#!/bin/bash -l
#SBATCH --job-name="S2_MODELNO_FRACFRACXX_SEEDSEEDX_S2TIME"
#SBATCH --account="icp013"
#SBATCH --mail-type=ALL
#SBATCH --mail-user=scat8499@ox.ac.uk
#SBATCH --time=20:00:00
#SBATCH --nodes=1
#SBATCH --ntasks-per-core=1
#SBATCH --ntasks-per-node=1
#SBATCH --cpus-per-task=12
#SBATCH --partition=normal
#SBATCH --constraint=gpu
#SBATCH --hint=nomultithread

module load daint-gpu
module load craype-accel-nvidia60

export OMP_NUM_THREADS=$SLURM_CPUS_PER_TASK
export CRAY_CUDA_MPS=1

modelID=MODELNO
fibFrac=FRACXX

for ((seed=0; seed<9+1; seed=seed+1))
do
for ((time=INIT; time<ENDY; time=time+5))
do
    sed -i -e "s/s2_${modelID}_FRAC${fibFrac}_SEEDSEEDX_S2TIME/s2_${modelID}_FRAC${fibFrac}_SEED${seed}_${time}/" S2_MODELNO_BASE.ini
    sed -i -e "s/start=S2TIME/start=${time}/" S2_MODELNO_BASE.ini
    sed -i -e "s/s1_${modelID}_FRAC${fibFrac}_SEEDSEEDX/s1_${modelID}_FRAC${fibFrac}_SEED${seed}/" S2_MODELNO_BASE.ini
    sed -i -e "s/SEEDSEEDX/SEED${seed}/" S2_MODELNO_BASE.ini

    srun ./bin/MonoAlg3D -c S2_MODELNO_BASE.ini

    sed -i -e "s/s2_${modelID}_FRAC${fibFrac}_SEED${seed}_${time}/s2_${modelID}_FRAC${fibFrac}_SEEDSEEDX_S2TIME/" S2_MODELNO_BASE.ini
    sed -i -e "s/start=${time}/start=S2TIME/" S2_MODELNO_BASE.ini
    sed -i -e "s/s1_${modelID}_FRAC${fibFrac}_SEED${seed}/s1_${modelID}_FRAC${fibFrac}_SEEDSEEDX/" S2_MODELNO_BASE.ini
    sed -i -e "s/SEED${seed}/SEEDSEEDX/" S2_MODELNO_BASE.ini
done
done
